export function deepClone(target) {
  if (typeof target === 'object' && target) {
      let cloneObj = {}
      for (const key in target) { // 遍历
          const val = target[key]
          if (typeof val === 'object' && val) {
              cloneObj[key] = deepClone(val) // 是对象就再次调用该函数递归
          } else {
              cloneObj[key] = val // 基本类型的话直接复制值
          }
      }
      return cloneObj
  } else {
      return target;
  }
}

// 判断内容是否含有表情字符，现有数据库不支持。
export function hasEmoji (str = '') {
  const reg = /[^\u0020-\u007E\u00A0-\u00BE\u2E80-\uA4CF\uF900-\uFAFF\uFE30-\uFE4F\uFF00-\uFFEF\u0080-\u009F\u2000-\u201f\u2026\u2022\u20ac\r\n]/g;
  return str.match(reg) && str.match(reg).length
}

// 单张图片上传
export const uploadImgServer = 'http://backend-api-02.newbee.ltd/manage-api/v1/upload/file'
// 多张图片上传
export const uploadImgsServer = 'http://backend-api-02.newbee.ltd/manage-api/v1/upload/files'
// 时间格式 年月日时分
export const formatTime = (time) => {
  if (time) {
    var now = new Date(time),
      y = now.getFullYear(),
      m = now.getMonth() + 1,
      d = now.getDate();
    return (
      y +
      "-" +
      (m < 10 ? "0" + m : m) +
      "-" +
      (d < 10 ? "0" + d : d) +
      " " +
      now.toTimeString().substr(0, 5)
    );
  } else {
    return null;
  }
}
// 时间格式 年月日
export const formatTimeDay = (time) => {
  if (time) {
    var now = new Date(time),
      y = now.getFullYear(),
      m = now.getMonth() + 1,
      d = now.getDate();
    return (
      y +
      "-" +
      (m < 10 ? "0" + m : m) +
      "-" +
      (d < 10 ? "0" + d : d)
    );
  } else {
    return null;
  }
}
export const pathMap = {
  Psychology: '咨询预约',
  PsychologyReserve: '咨询预约',
  Record: '咨询预约',
  Term:'教师排班',
  Scheduling:'教师排班',
  SchedulingDetail:'教师排班',
  Science: '科普调适',
  ScienceDetail: '科普调适',
  Experience: '解忧杂货铺',
  ExperienceDetail: '解忧杂货铺',
  ExperienceAudit: '解忧杂货铺',
  Coach: '个案辅导',
  Assessment: '个案辅导',
  Interview: '个案辅导',
  Study:'数字学习馆',
  StudySecond:'数字学习馆',
  StudyDetail:'数字学习馆',
  UserExtraInfo:'基本信息导入',
  InfoDetail:'基本信息导入',
}