import { createRouter, createWebHashHistory } from 'vue-router'

const router = createRouter({
  history: createWebHashHistory(), // hash模式：createWebHashHistory，history模式：createWebHistory
  routes: [
    {
      path: '/',
      redirect: '/psychology'
    },
    //心理咨询
    {
      path: '/psychology',
      name: 'Psychology',
      component: () => import(/* webpackChunkName: "psychology" */ '../views/Psychology/Psychology.vue')
    },
    {
      path: '/psychology_reserve',
      name: 'PsychologyReserve',
      component: () => import(/* webpackChunkName: "PsychologyReserve" */ '../views/Psychology/Reserve.vue')
    },
    {
      path: '/psychology_record',
      name: 'PsychologyRecord',
      component: () => import(/* webpackChunkName: "PsychologyRecord" */ '../views/Psychology/Record.vue')
    },
    //教室排班
    {
      path: '/term',
      name: 'Term',
      component: () => import(/* webpackChunkName: "Term" */ '../views/Scheduling/Term.vue')
    },
    {
      path: '/scheduling',
      name: 'Scheduling',
      component: () => import(/* webpackChunkName: "Scheduling" */ '../views/Scheduling/Scheduling.vue')
    },
    {
      path: '/scheduling_detail',
      name: 'SchedulingDetail',
      component: () => import(/* webpackChunkName: "Scheduling" */ '../views/Scheduling/Detail.vue')
    },
    //个案辅导
    {
      path: '/coach',
      name: 'Coach',
      component: () => import(/* webpackChunkName: "coach" */ '../views/Coach/Coach.vue')
    },
    {
      path: '/assessment',
      name: 'Assessment',
      component: () => import(/* webpackChunkName: "Assessment" */ '../views/Coach/Assessment.vue')
    },
    {
      path: '/interview',
      name: 'Interview',
      component: () => import(/* webpackChunkName: "Interview" */ '../views/Coach/Interview.vue')
    },
    // 基本信息导入
    {
      path: '/userExtraInfo',
      name: 'UserExtraInfo',
      component: () => import(/* webpackChunkName: "UserExtraInfo" */ '../views/UserExtraInfo/UserExtraInfo.vue')
    },
    {
      path: '/infoDetail',
      name: 'InfoDetail',
      component: () => import(/* webpackChunkName: "InfoDetail" */ '../views/UserExtraInfo/InfoDetail.vue')
    },
    //科普调适
    {
      path: '/science',
      name: 'Science',
      component: () => import(/* webpackChunkName: "Science" */ '../views/Science/Science.vue'),
    },
    {
      path: '/science_detail',
      name: 'ScienceDetail',
      component: () => import(/* webpackChunkName: "ScienceDetail" */ '../views/Science/Detail.vue'),
    },
    //经验分享
    {
      path: '/experience',
      name: 'Experience',
      component: () => import(/* webpackChunkName: "Experience" */ '../views/Experience/Experience.vue'),
    },
    {
      path: '/experience_detail',
      name: 'ExperienceDetail',
      component: () => import(/* webpackChunkName: "ExperienceDetail" */ '../views/Experience/Detail.vue'),
    },
    {
      path: '/experience_audit',
      name: 'ExperienceAudit',
      component: () => import(/* webpackChunkName: "Experience" */ '../views/Experience/Audit.vue'),
    },
    //数字学习馆
    {
      path: '/study',
      name: 'Study',
      component: () => import(/* webpackChunkName: "Study" */ '../views/Study/Study.vue'),
    },
    {
      path: '/study_second',
      name: 'StudySecond',
      component: () => import(/* webpackChunkName: "StudySecond" */ '../views/Study/Second.vue'),
    },
    {
      path: '/study_detail',
      name: 'StudyDetail',
      component: () => import(/* webpackChunkName: "StudyDetail" */ '../views/Study/Detail.vue'),
    },
  ]
})

export default router